package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVaultLockRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultLockRequest = {
    import GetVaultLockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultLockRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultLockRequest.ReadOnly =
    zio.aws.glacier.model.GetVaultLockRequest.wrap(buildAwsValue())
}
object GetVaultLockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultLockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultLockRequest =
      zio.aws.glacier.model.GetVaultLockRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultLockRequest
  ) extends zio.aws.glacier.model.GetVaultLockRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultLockRequest
  ): zio.aws.glacier.model.GetVaultLockRequest.ReadOnly = new Wrapper(impl)
}
