package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetVaultNotificationsResponse(
    vaultNotificationConfig: Option[
      zio.aws.glacier.model.VaultNotificationConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse = {
    import GetVaultNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse
      .builder()
      .optionallyWith(
        vaultNotificationConfig.map(value => value.buildAwsValue())
      )(_.vaultNotificationConfig)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly =
    zio.aws.glacier.model.GetVaultNotificationsResponse.wrap(buildAwsValue())
}
object GetVaultNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultNotificationsResponse =
      zio.aws.glacier.model.GetVaultNotificationsResponse(
        vaultNotificationConfig.map(value => value.asEditable)
      )
    def vaultNotificationConfig
        : Option[zio.aws.glacier.model.VaultNotificationConfig.ReadOnly]
    def getVaultNotificationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.VaultNotificationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vaultNotificationConfig",
      vaultNotificationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse
  ) extends zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly {
    override val vaultNotificationConfig
        : Option[zio.aws.glacier.model.VaultNotificationConfig.ReadOnly] = scala
      .Option(impl.vaultNotificationConfig())
      .map(value => zio.aws.glacier.model.VaultNotificationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultNotificationsResponse
  ): zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
