package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Grant(
    grantee: Option[zio.aws.glacier.model.Grantee] = None,
    permission: Option[zio.aws.glacier.model.Permission] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.glacier.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.Grant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.Grant.ReadOnly =
    zio.aws.glacier.model.Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.glacier.model.Grant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.Grant = zio.aws.glacier.model.Grant(
      grantee.map(value => value.asEditable),
      permission.map(value => value)
    )
    def grantee: Option[zio.aws.glacier.model.Grantee.ReadOnly]
    def permission: Option[zio.aws.glacier.model.Permission]
    def getGrantee: ZIO[Any, AwsError, zio.aws.glacier.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getPermission: ZIO[Any, AwsError, zio.aws.glacier.model.Permission] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.Grant
  ) extends zio.aws.glacier.model.Grant.ReadOnly {
    override val grantee: Option[zio.aws.glacier.model.Grantee.ReadOnly] = scala
      .Option(impl.grantee())
      .map(value => zio.aws.glacier.model.Grantee.wrap(value))
    override val permission: Option[zio.aws.glacier.model.Permission] = scala
      .Option(impl.permission())
      .map(value => zio.aws.glacier.model.Permission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.Grant
  ): zio.aws.glacier.model.Grant.ReadOnly = new Wrapper(impl)
}
