package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InitiateMultipartUploadRequest(
    accountId: String,
    vaultName: String,
    archiveDescription: Option[String] = None,
    partSize: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest = {
    import InitiateMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(partSize.map(value => value: java.lang.String))(
        _.partSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.InitiateMultipartUploadRequest.ReadOnly =
    zio.aws.glacier.model.InitiateMultipartUploadRequest.wrap(buildAwsValue())
}
object InitiateMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateMultipartUploadRequest =
      zio.aws.glacier.model.InitiateMultipartUploadRequest(
        accountId,
        vaultName,
        archiveDescription.map(value => value),
        partSize.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def archiveDescription: Option[String]
    def partSize: Option[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getPartSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("partSize", partSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest
  ) extends zio.aws.glacier.model.InitiateMultipartUploadRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val archiveDescription: Option[String] =
      scala.Option(impl.archiveDescription()).map(value => value: String)
    override val partSize: Option[String] =
      scala.Option(impl.partSize()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest
  ): zio.aws.glacier.model.InitiateMultipartUploadRequest.ReadOnly =
    new Wrapper(impl)
}
