package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InitiateVaultLockRequest(
    accountId: String,
    vaultName: String,
    policy: Option[zio.aws.glacier.model.VaultLockPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest = {
    import InitiateVaultLockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InitiateVaultLockRequest.ReadOnly =
    zio.aws.glacier.model.InitiateVaultLockRequest.wrap(buildAwsValue())
}
object InitiateVaultLockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateVaultLockRequest =
      zio.aws.glacier.model.InitiateVaultLockRequest(
        accountId,
        vaultName,
        policy.map(value => value.asEditable)
      )
    def accountId: String
    def vaultName: String
    def policy: Option[zio.aws.glacier.model.VaultLockPolicy.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getPolicy
        : ZIO[Any, AwsError, zio.aws.glacier.model.VaultLockPolicy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest
  ) extends zio.aws.glacier.model.InitiateVaultLockRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val policy
        : Option[zio.aws.glacier.model.VaultLockPolicy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.glacier.model.VaultLockPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest
  ): zio.aws.glacier.model.InitiateVaultLockRequest.ReadOnly = new Wrapper(impl)
}
