package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InitiateVaultLockResponse(lockId: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse = {
    import InitiateVaultLockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse
      .builder()
      .optionallyWith(lockId.map(value => value: java.lang.String))(_.lockId)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly =
    zio.aws.glacier.model.InitiateVaultLockResponse.wrap(buildAwsValue())
}
object InitiateVaultLockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateVaultLockResponse =
      zio.aws.glacier.model
        .InitiateVaultLockResponse(lockId.map(value => value))
    def lockId: Option[String]
    def getLockId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lockId", lockId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse
  ) extends zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly {
    override val lockId: Option[String] =
      scala.Option(impl.lockId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateVaultLockResponse
  ): zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly = new Wrapper(
    impl
  )
}
