package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class InventoryRetrievalJobDescription(
    format: Option[String] = None,
    startDate: Option[DateTime] = None,
    endDate: Option[DateTime] = None,
    limit: Option[String] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription = {
    import InventoryRetrievalJobDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
      .builder()
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(
        startDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endDate)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly =
    zio.aws.glacier.model.InventoryRetrievalJobDescription.wrap(buildAwsValue())
}
object InventoryRetrievalJobDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InventoryRetrievalJobDescription =
      zio.aws.glacier.model.InventoryRetrievalJobDescription(
        format.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def format: Option[String]
    def startDate: Option[DateTime]
    def endDate: Option[DateTime]
    def limit: Option[String]
    def marker: Option[String]
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ) extends zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly {
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val startDate: Option[DateTime] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.glacier.model.primitives.DateTime(value))
    override val endDate: Option[DateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.glacier.model.primitives.DateTime(value))
    override val limit: Option[String] =
      scala.Option(impl.limit()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ): zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly =
    new Wrapper(impl)
}
