package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryRetrievalJobInput(
    startDate: Option[String] = None,
    endDate: Option[String] = None,
    limit: Option[String] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput = {
    import InventoryRetrievalJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
      .builder()
      .optionallyWith(startDate.map(value => value: java.lang.String))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly =
    zio.aws.glacier.model.InventoryRetrievalJobInput.wrap(buildAwsValue())
}
object InventoryRetrievalJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InventoryRetrievalJobInput =
      zio.aws.glacier.model.InventoryRetrievalJobInput(
        startDate.map(value => value),
        endDate.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def startDate: Option[String]
    def endDate: Option[String]
    def limit: Option[String]
    def marker: Option[String]
    def getStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ) extends zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly {
    override val startDate: Option[String] =
      scala.Option(impl.startDate()).map(value => value: String)
    override val endDate: Option[String] =
      scala.Option(impl.endDate()).map(value => value: String)
    override val limit: Option[String] =
      scala.Option(impl.limit()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ): zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly = new Wrapper(
    impl
  )
}
