package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobParameters(
    format: Option[String] = None,
    `type`: Option[String] = None,
    archiveId: Option[String] = None,
    description: Option[String] = None,
    snsTopic: Option[String] = None,
    retrievalByteRange: Option[String] = None,
    tier: Option[String] = None,
    inventoryRetrievalParameters: Option[
      zio.aws.glacier.model.InventoryRetrievalJobInput
    ] = None,
    selectParameters: Option[zio.aws.glacier.model.SelectParameters] = None,
    outputLocation: Option[zio.aws.glacier.model.OutputLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.JobParameters = {
    import JobParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.JobParameters
      .builder()
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(archiveId.map(value => value: java.lang.String))(
        _.archiveId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(snsTopic.map(value => value: java.lang.String))(
        _.snsTopic
      )
      .optionallyWith(retrievalByteRange.map(value => value: java.lang.String))(
        _.retrievalByteRange
      )
      .optionallyWith(tier.map(value => value: java.lang.String))(_.tier)
      .optionallyWith(
        inventoryRetrievalParameters.map(value => value.buildAwsValue())
      )(_.inventoryRetrievalParameters)
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.JobParameters.ReadOnly =
    zio.aws.glacier.model.JobParameters.wrap(buildAwsValue())
}
object JobParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.JobParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.JobParameters =
      zio.aws.glacier.model.JobParameters(
        format.map(value => value),
        `type`.map(value => value),
        archiveId.map(value => value),
        description.map(value => value),
        snsTopic.map(value => value),
        retrievalByteRange.map(value => value),
        tier.map(value => value),
        inventoryRetrievalParameters.map(value => value.asEditable),
        selectParameters.map(value => value.asEditable),
        outputLocation.map(value => value.asEditable)
      )
    def format: Option[String]
    def `type`: Option[String]
    def archiveId: Option[String]
    def description: Option[String]
    def snsTopic: Option[String]
    def retrievalByteRange: Option[String]
    def tier: Option[String]
    def inventoryRetrievalParameters
        : Option[zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly]
    def selectParameters
        : Option[zio.aws.glacier.model.SelectParameters.ReadOnly]
    def outputLocation: Option[zio.aws.glacier.model.OutputLocation.ReadOnly]
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getArchiveId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveId", archiveId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSnsTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getRetrievalByteRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("retrievalByteRange", retrievalByteRange)
    def getTier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tier", tier)
    def getInventoryRetrievalParameters: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inventoryRetrievalParameters",
      inventoryRetrievalParameters
    )
    def getSelectParameters
        : ZIO[Any, AwsError, zio.aws.glacier.model.SelectParameters.ReadOnly] =
      AwsError.unwrapOptionField("selectParameters", selectParameters)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.glacier.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.JobParameters
  ) extends zio.aws.glacier.model.JobParameters.ReadOnly {
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val archiveId: Option[String] =
      scala.Option(impl.archiveId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val snsTopic: Option[String] =
      scala.Option(impl.snsTopic()).map(value => value: String)
    override val retrievalByteRange: Option[String] =
      scala.Option(impl.retrievalByteRange()).map(value => value: String)
    override val tier: Option[String] =
      scala.Option(impl.tier()).map(value => value: String)
    override val inventoryRetrievalParameters
        : Option[zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly] =
      scala
        .Option(impl.inventoryRetrievalParameters())
        .map(value =>
          zio.aws.glacier.model.InventoryRetrievalJobInput.wrap(value)
        )
    override val selectParameters
        : Option[zio.aws.glacier.model.SelectParameters.ReadOnly] = scala
      .Option(impl.selectParameters())
      .map(value => zio.aws.glacier.model.SelectParameters.wrap(value))
    override val outputLocation
        : Option[zio.aws.glacier.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.glacier.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.JobParameters
  ): zio.aws.glacier.model.JobParameters.ReadOnly = new Wrapper(impl)
}
