package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    accountId: String,
    vaultName: String,
    limit: Option[String] = None,
    marker: Option[String] = None,
    statuscode: Option[String] = None,
    completed: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListJobsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(statuscode.map(value => value: java.lang.String))(
        _.statuscode
      )
      .optionallyWith(completed.map(value => value: java.lang.String))(
        _.completed
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListJobsRequest.ReadOnly =
    zio.aws.glacier.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListJobsRequest =
      zio.aws.glacier.model.ListJobsRequest(
        accountId,
        vaultName,
        limit.map(value => value),
        marker.map(value => value),
        statuscode.map(value => value),
        completed.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def limit: Option[String]
    def marker: Option[String]
    def statuscode: Option[String]
    def completed: Option[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getStatuscode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statuscode", statuscode)
    def getCompleted: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("completed", completed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListJobsRequest
  ) extends zio.aws.glacier.model.ListJobsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val limit: Option[String] =
      scala.Option(impl.limit()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val statuscode: Option[String] =
      scala.Option(impl.statuscode()).map(value => value: String)
    override val completed: Option[String] =
      scala.Option(impl.completed()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListJobsRequest
  ): zio.aws.glacier.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
