package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMultipartUploadsResponse(
    uploadsList: Option[Iterable[zio.aws.glacier.model.UploadListElement]] =
      None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse = {
    import ListMultipartUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
      .builder()
      .optionallyWith(
        uploadsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploadsList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly =
    zio.aws.glacier.model.ListMultipartUploadsResponse.wrap(buildAwsValue())
}
object ListMultipartUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListMultipartUploadsResponse =
      zio.aws.glacier.model.ListMultipartUploadsResponse(
        uploadsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def uploadsList
        : Option[List[zio.aws.glacier.model.UploadListElement.ReadOnly]]
    def marker: Option[String]
    def getUploadsList: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.UploadListElement.ReadOnly
    ]] = AwsError.unwrapOptionField("uploadsList", uploadsList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ) extends zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly {
    override val uploadsList
        : Option[List[zio.aws.glacier.model.UploadListElement.ReadOnly]] = scala
      .Option(impl.uploadsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.glacier.model.UploadListElement.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ): zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly = new Wrapper(
    impl
  )
}
