package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPartsResponse(
    multipartUploadId: Option[String] = None,
    vaultARN: Option[String] = None,
    archiveDescription: Option[String] = None,
    partSizeInBytes: Option[Long] = None,
    creationDate: Option[String] = None,
    parts: Option[Iterable[zio.aws.glacier.model.PartListElement]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListPartsResponse = {
    import ListPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListPartsResponse
      .builder()
      .optionallyWith(multipartUploadId.map(value => value: java.lang.String))(
        _.multipartUploadId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(partSizeInBytes.map(value => value: java.lang.Long))(
        _.partSizeInBytes
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListPartsResponse.ReadOnly =
    zio.aws.glacier.model.ListPartsResponse.wrap(buildAwsValue())
}
object ListPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListPartsResponse =
      zio.aws.glacier.model.ListPartsResponse(
        multipartUploadId.map(value => value),
        vaultARN.map(value => value),
        archiveDescription.map(value => value),
        partSizeInBytes.map(value => value),
        creationDate.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def multipartUploadId: Option[String]
    def vaultARN: Option[String]
    def archiveDescription: Option[String]
    def partSizeInBytes: Option[Long]
    def creationDate: Option[String]
    def parts: Option[List[zio.aws.glacier.model.PartListElement.ReadOnly]]
    def marker: Option[String]
    def getMultipartUploadId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multipartUploadId", multipartUploadId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getPartSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("partSizeInBytes", partSizeInBytes)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getParts: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.PartListElement.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", parts)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ) extends zio.aws.glacier.model.ListPartsResponse.ReadOnly {
    override val multipartUploadId: Option[String] =
      scala.Option(impl.multipartUploadId()).map(value => value: String)
    override val vaultARN: Option[String] =
      scala.Option(impl.vaultARN()).map(value => value: String)
    override val archiveDescription: Option[String] =
      scala.Option(impl.archiveDescription()).map(value => value: String)
    override val partSizeInBytes: Option[Long] =
      scala.Option(impl.partSizeInBytes()).map(value => value: Long)
    override val creationDate: Option[String] =
      scala.Option(impl.creationDate()).map(value => value: String)
    override val parts
        : Option[List[zio.aws.glacier.model.PartListElement.ReadOnly]] = scala
      .Option(impl.parts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.glacier.model.PartListElement.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ): zio.aws.glacier.model.ListPartsResponse.ReadOnly = new Wrapper(impl)
}
