package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListProvisionedCapacityRequest(accountId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest = {
    import ListProvisionedCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.ListProvisionedCapacityRequest.ReadOnly =
    zio.aws.glacier.model.ListProvisionedCapacityRequest.wrap(buildAwsValue())
}
object ListProvisionedCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListProvisionedCapacityRequest =
      zio.aws.glacier.model.ListProvisionedCapacityRequest(accountId)
    def accountId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest
  ) extends zio.aws.glacier.model.ListProvisionedCapacityRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest
  ): zio.aws.glacier.model.ListProvisionedCapacityRequest.ReadOnly =
    new Wrapper(impl)
}
