package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class ListTagsForVaultResponse(
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse = {
    import ListTagsForVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly =
    zio.aws.glacier.model.ListTagsForVaultResponse.wrap(buildAwsValue())
}
object ListTagsForVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListTagsForVaultResponse =
      zio.aws.glacier.model.ListTagsForVaultResponse(tags.map(value => value))
    def tags: Option[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse
  ) extends zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly {
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.glacier.model.primitives
              .TagKey(key) -> zio.aws.glacier.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListTagsForVaultResponse
  ): zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly = new Wrapper(impl)
}
