package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputSerialization(
    csv: Option[zio.aws.glacier.model.CSVOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.OutputSerialization = {
    import OutputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.OutputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.OutputSerialization.ReadOnly =
    zio.aws.glacier.model.OutputSerialization.wrap(buildAwsValue())
}
object OutputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.OutputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.OutputSerialization =
      zio.aws.glacier.model
        .OutputSerialization(csv.map(value => value.asEditable))
    def csv: Option[zio.aws.glacier.model.CSVOutput.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.glacier.model.CSVOutput.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.OutputSerialization
  ) extends zio.aws.glacier.model.OutputSerialization.ReadOnly {
    override val csv: Option[zio.aws.glacier.model.CSVOutput.ReadOnly] = scala
      .Option(impl.csv())
      .map(value => zio.aws.glacier.model.CSVOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.OutputSerialization
  ): zio.aws.glacier.model.OutputSerialization.ReadOnly = new Wrapper(impl)
}
