package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait Permission {
  def unwrap: software.amazon.awssdk.services.glacier.model.Permission
}
object Permission {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.Permission
  ): zio.aws.glacier.model.Permission = value match {
    case software.amazon.awssdk.services.glacier.model.Permission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.Permission.FULL_CONTROL =>
      val r = FULL_CONTROL
      r
    case software.amazon.awssdk.services.glacier.model.Permission.WRITE =>
      val r = WRITE
      r
    case software.amazon.awssdk.services.glacier.model.Permission.WRITE_ACP =>
      val r = WRITE_ACP
      r
    case software.amazon.awssdk.services.glacier.model.Permission.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.glacier.model.Permission.READ_ACP =>
      val r = READ_ACP
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_CONTROL extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.FULL_CONTROL
  }
  case object WRITE extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.WRITE
  }
  case object WRITE_ACP extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.WRITE_ACP
  }
  case object READ extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.READ
  }
  case object READ_ACP extends zio.aws.glacier.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.Permission =
      software.amazon.awssdk.services.glacier.model.Permission.READ_ACP
  }
}
