package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PurchaseProvisionedCapacityRequest(accountId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest = {
    import PurchaseProvisionedCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.PurchaseProvisionedCapacityRequest.ReadOnly =
    zio.aws.glacier.model.PurchaseProvisionedCapacityRequest
      .wrap(buildAwsValue())
}
object PurchaseProvisionedCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.PurchaseProvisionedCapacityRequest =
      zio.aws.glacier.model.PurchaseProvisionedCapacityRequest(accountId)
    def accountId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest
  ) extends zio.aws.glacier.model.PurchaseProvisionedCapacityRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest
  ): zio.aws.glacier.model.PurchaseProvisionedCapacityRequest.ReadOnly =
    new Wrapper(impl)
}
