package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseProvisionedCapacityResponse(
    capacityId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse = {
    import PurchaseProvisionedCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse
      .builder()
      .optionallyWith(capacityId.map(value => value: java.lang.String))(
        _.capacityId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly =
    zio.aws.glacier.model.PurchaseProvisionedCapacityResponse
      .wrap(buildAwsValue())
}
object PurchaseProvisionedCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.PurchaseProvisionedCapacityResponse =
      zio.aws.glacier.model
        .PurchaseProvisionedCapacityResponse(capacityId.map(value => value))
    def capacityId: Option[String]
    def getCapacityId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityId", capacityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse
  ) extends zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly {
    override val capacityId: Option[String] =
      scala.Option(impl.capacityId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityResponse
  ): zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
