package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait QuoteFields {
  def unwrap: software.amazon.awssdk.services.glacier.model.QuoteFields
}
object QuoteFields {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.QuoteFields
  ): zio.aws.glacier.model.QuoteFields = value match {
    case software.amazon.awssdk.services.glacier.model.QuoteFields.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.QuoteFields.ALWAYS =>
      val r = ALWAYS
      r
    case software.amazon.awssdk.services.glacier.model.QuoteFields.ASNEEDED =>
      val r = ASNEEDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.QuoteFields {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.QuoteFields =
      software.amazon.awssdk.services.glacier.model.QuoteFields.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS extends zio.aws.glacier.model.QuoteFields {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.QuoteFields =
      software.amazon.awssdk.services.glacier.model.QuoteFields.ALWAYS
  }
  case object ASNEEDED extends zio.aws.glacier.model.QuoteFields {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.QuoteFields =
      software.amazon.awssdk.services.glacier.model.QuoteFields.ASNEEDED
  }
}
