package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromVaultRequest(
    accountId: String,
    vaultName: String,
    tagKeys: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest = {
    import RemoveTagsFromVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.RemoveTagsFromVaultRequest.ReadOnly =
    zio.aws.glacier.model.RemoveTagsFromVaultRequest.wrap(buildAwsValue())
}
object RemoveTagsFromVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.RemoveTagsFromVaultRequest =
      zio.aws.glacier.model.RemoveTagsFromVaultRequest(
        accountId,
        vaultName,
        tagKeys.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def tagKeys: Option[List[String]]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest
  ) extends zio.aws.glacier.model.RemoveTagsFromVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest
  ): zio.aws.glacier.model.RemoveTagsFromVaultRequest.ReadOnly = new Wrapper(
    impl
  )
}
