package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucketName: Option[String] = None,
    prefix: Option[String] = None,
    encryption: Option[zio.aws.glacier.model.Encryption] = None,
    cannedACL: Option[zio.aws.glacier.model.CannedACL] = None,
    accessControlList: Option[Iterable[zio.aws.glacier.model.Grant]] = None,
    tagging: Option[Map[String, String]] = None,
    userMetadata: Option[Map[String, String]] = None,
    storageClass: Option[zio.aws.glacier.model.StorageClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.S3Location
      .builder()
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(cannedACL.map(value => value.unwrap))(_.cannedACL)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        tagging.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tagging)
      .optionallyWith(
        userMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.userMetadata)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.S3Location.ReadOnly =
    zio.aws.glacier.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.S3Location =
      zio.aws.glacier.model.S3Location(
        bucketName.map(value => value),
        prefix.map(value => value),
        encryption.map(value => value.asEditable),
        cannedACL.map(value => value),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagging.map(value => value),
        userMetadata.map(value => value),
        storageClass.map(value => value)
      )
    def bucketName: Option[String]
    def prefix: Option[String]
    def encryption: Option[zio.aws.glacier.model.Encryption.ReadOnly]
    def cannedACL: Option[zio.aws.glacier.model.CannedACL]
    def accessControlList: Option[List[zio.aws.glacier.model.Grant.ReadOnly]]
    def tagging: Option[Map[String, String]]
    def userMetadata: Option[Map[String, String]]
    def storageClass: Option[zio.aws.glacier.model.StorageClass]
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getEncryption
        : ZIO[Any, AwsError, zio.aws.glacier.model.Encryption.ReadOnly] =
      AwsError.unwrapOptionField("encryption", encryption)
    def getCannedACL: ZIO[Any, AwsError, zio.aws.glacier.model.CannedACL] =
      AwsError.unwrapOptionField("cannedACL", cannedACL)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.glacier.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getTagging: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getUserMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.glacier.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.S3Location
  ) extends zio.aws.glacier.model.S3Location.ReadOnly {
    override val bucketName: Option[String] =
      scala.Option(impl.bucketName()).map(value => value: String)
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val encryption: Option[zio.aws.glacier.model.Encryption.ReadOnly] =
      scala
        .Option(impl.encryption())
        .map(value => zio.aws.glacier.model.Encryption.wrap(value))
    override val cannedACL: Option[zio.aws.glacier.model.CannedACL] = scala
      .Option(impl.cannedACL())
      .map(value => zio.aws.glacier.model.CannedACL.wrap(value))
    override val accessControlList
        : Option[List[zio.aws.glacier.model.Grant.ReadOnly]] = scala
      .Option(impl.accessControlList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.glacier.model.Grant.wrap(item)
        }.toList
      )
    override val tagging: Option[Map[String, String]] = scala
      .Option(impl.tagging())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val userMetadata: Option[Map[String, String]] = scala
      .Option(impl.userMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val storageClass: Option[zio.aws.glacier.model.StorageClass] =
      scala
        .Option(impl.storageClass())
        .map(value => zio.aws.glacier.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.S3Location
  ): zio.aws.glacier.model.S3Location.ReadOnly = new Wrapper(impl)
}
