package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SelectParameters(
    inputSerialization: Option[zio.aws.glacier.model.InputSerialization] = None,
    expressionType: Option[zio.aws.glacier.model.ExpressionType] = None,
    expression: Option[String] = None,
    outputSerialization: Option[zio.aws.glacier.model.OutputSerialization] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.SelectParameters = {
    import SelectParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.SelectParameters
      .builder()
      .optionallyWith(inputSerialization.map(value => value.buildAwsValue()))(
        _.inputSerialization
      )
      .optionallyWith(expressionType.map(value => value.unwrap))(
        _.expressionType
      )
      .optionallyWith(expression.map(value => value: java.lang.String))(
        _.expression
      )
      .optionallyWith(outputSerialization.map(value => value.buildAwsValue()))(
        _.outputSerialization
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.SelectParameters.ReadOnly =
    zio.aws.glacier.model.SelectParameters.wrap(buildAwsValue())
}
object SelectParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.SelectParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.SelectParameters =
      zio.aws.glacier.model.SelectParameters(
        inputSerialization.map(value => value.asEditable),
        expressionType.map(value => value),
        expression.map(value => value),
        outputSerialization.map(value => value.asEditable)
      )
    def inputSerialization
        : Option[zio.aws.glacier.model.InputSerialization.ReadOnly]
    def expressionType: Option[zio.aws.glacier.model.ExpressionType]
    def expression: Option[String]
    def outputSerialization
        : Option[zio.aws.glacier.model.OutputSerialization.ReadOnly]
    def getInputSerialization: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.InputSerialization.ReadOnly
    ] = AwsError.unwrapOptionField("inputSerialization", inputSerialization)
    def getExpressionType
        : ZIO[Any, AwsError, zio.aws.glacier.model.ExpressionType] =
      AwsError.unwrapOptionField("expressionType", expressionType)
    def getExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expression", expression)
    def getOutputSerialization: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.OutputSerialization.ReadOnly
    ] = AwsError.unwrapOptionField("outputSerialization", outputSerialization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.SelectParameters
  ) extends zio.aws.glacier.model.SelectParameters.ReadOnly {
    override val inputSerialization
        : Option[zio.aws.glacier.model.InputSerialization.ReadOnly] = scala
      .Option(impl.inputSerialization())
      .map(value => zio.aws.glacier.model.InputSerialization.wrap(value))
    override val expressionType: Option[zio.aws.glacier.model.ExpressionType] =
      scala
        .Option(impl.expressionType())
        .map(value => zio.aws.glacier.model.ExpressionType.wrap(value))
    override val expression: Option[String] =
      scala.Option(impl.expression()).map(value => value: String)
    override val outputSerialization
        : Option[zio.aws.glacier.model.OutputSerialization.ReadOnly] = scala
      .Option(impl.outputSerialization())
      .map(value => zio.aws.glacier.model.OutputSerialization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.SelectParameters
  ): zio.aws.glacier.model.SelectParameters.ReadOnly = new Wrapper(impl)
}
