package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetDataRetrievalPolicyRequest(
    accountId: String,
    policy: Option[zio.aws.glacier.model.DataRetrievalPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest = {
    import SetDataRetrievalPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.SetDataRetrievalPolicyRequest.ReadOnly =
    zio.aws.glacier.model.SetDataRetrievalPolicyRequest.wrap(buildAwsValue())
}
object SetDataRetrievalPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.SetDataRetrievalPolicyRequest =
      zio.aws.glacier.model.SetDataRetrievalPolicyRequest(
        accountId,
        policy.map(value => value.asEditable)
      )
    def accountId: String
    def policy: Option[zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest
  ) extends zio.aws.glacier.model.SetDataRetrievalPolicyRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val policy
        : Option[zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.glacier.model.DataRetrievalPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest
  ): zio.aws.glacier.model.SetDataRetrievalPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
