package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetVaultAccessPolicyRequest(
    accountId: String,
    vaultName: String,
    policy: Option[zio.aws.glacier.model.VaultAccessPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest = {
    import SetVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.SetVaultAccessPolicyRequest.ReadOnly =
    zio.aws.glacier.model.SetVaultAccessPolicyRequest.wrap(buildAwsValue())
}
object SetVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.SetVaultAccessPolicyRequest =
      zio.aws.glacier.model.SetVaultAccessPolicyRequest(
        accountId,
        vaultName,
        policy.map(value => value.asEditable)
      )
    def accountId: String
    def vaultName: String
    def policy: Option[zio.aws.glacier.model.VaultAccessPolicy.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getPolicy
        : ZIO[Any, AwsError, zio.aws.glacier.model.VaultAccessPolicy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest
  ) extends zio.aws.glacier.model.SetVaultAccessPolicyRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val policy
        : Option[zio.aws.glacier.model.VaultAccessPolicy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.glacier.model.VaultAccessPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest
  ): zio.aws.glacier.model.SetVaultAccessPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
