package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait StatusCode {
  def unwrap: software.amazon.awssdk.services.glacier.model.StatusCode
}
object StatusCode {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.StatusCode
  ): zio.aws.glacier.model.StatusCode = value match {
    case software.amazon.awssdk.services.glacier.model.StatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.StatusCode.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.glacier.model.StatusCode.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.glacier.model.StatusCode.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StatusCode =
      software.amazon.awssdk.services.glacier.model.StatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.glacier.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StatusCode =
      software.amazon.awssdk.services.glacier.model.StatusCode.IN_PROGRESS
  }
  case object Succeeded extends zio.aws.glacier.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StatusCode =
      software.amazon.awssdk.services.glacier.model.StatusCode.SUCCEEDED
  }
  case object Failed extends zio.aws.glacier.model.StatusCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StatusCode =
      software.amazon.awssdk.services.glacier.model.StatusCode.FAILED
  }
}
