package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait StorageClass {
  def unwrap: software.amazon.awssdk.services.glacier.model.StorageClass
}
object StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.StorageClass
  ): zio.aws.glacier.model.StorageClass = value match {
    case software.amazon.awssdk.services.glacier.model.StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.StorageClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.glacier.model.StorageClass.REDUCED_REDUNDANCY =>
      val r = REDUCED_REDUNDANCY
      r
    case software.amazon.awssdk.services.glacier.model.StorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StorageClass =
      software.amazon.awssdk.services.glacier.model.StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.glacier.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StorageClass =
      software.amazon.awssdk.services.glacier.model.StorageClass.STANDARD
  }
  case object REDUCED_REDUNDANCY extends zio.aws.glacier.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StorageClass =
      software.amazon.awssdk.services.glacier.model.StorageClass.REDUCED_REDUNDANCY
  }
  case object STANDARD_IA extends zio.aws.glacier.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.StorageClass =
      software.amazon.awssdk.services.glacier.model.StorageClass.STANDARD_IA
  }
}
