package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.glacier.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.Type
  ): zio.aws.glacier.model.Type = value match {
    case software.amazon.awssdk.services.glacier.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.Type.AMAZON_CUSTOMER_BY_EMAIL =>
      val r = AmazonCustomerByEmail
      r
    case software.amazon.awssdk.services.glacier.model.Type.CANONICAL_USER =>
      val r = CanonicalUser
      r
    case software.amazon.awssdk.services.glacier.model.Type.GROUP =>
      val r = Group
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.Type {
    override def unwrap: software.amazon.awssdk.services.glacier.model.Type =
      software.amazon.awssdk.services.glacier.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object AmazonCustomerByEmail extends zio.aws.glacier.model.Type {
    override def unwrap: software.amazon.awssdk.services.glacier.model.Type =
      software.amazon.awssdk.services.glacier.model.Type.AMAZON_CUSTOMER_BY_EMAIL
  }
  case object CanonicalUser extends zio.aws.glacier.model.Type {
    override def unwrap: software.amazon.awssdk.services.glacier.model.Type =
      software.amazon.awssdk.services.glacier.model.Type.CANONICAL_USER
  }
  case object Group extends zio.aws.glacier.model.Type {
    override def unwrap: software.amazon.awssdk.services.glacier.model.Type =
      software.amazon.awssdk.services.glacier.model.Type.GROUP
  }
}
