package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UploadListElement(
    multipartUploadId: Option[String] = None,
    vaultARN: Option[String] = None,
    archiveDescription: Option[String] = None,
    partSizeInBytes: Option[Long] = None,
    creationDate: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadListElement = {
    import UploadListElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadListElement
      .builder()
      .optionallyWith(multipartUploadId.map(value => value: java.lang.String))(
        _.multipartUploadId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(partSizeInBytes.map(value => value: java.lang.Long))(
        _.partSizeInBytes
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadListElement.ReadOnly =
    zio.aws.glacier.model.UploadListElement.wrap(buildAwsValue())
}
object UploadListElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadListElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadListElement =
      zio.aws.glacier.model.UploadListElement(
        multipartUploadId.map(value => value),
        vaultARN.map(value => value),
        archiveDescription.map(value => value),
        partSizeInBytes.map(value => value),
        creationDate.map(value => value)
      )
    def multipartUploadId: Option[String]
    def vaultARN: Option[String]
    def archiveDescription: Option[String]
    def partSizeInBytes: Option[Long]
    def creationDate: Option[String]
    def getMultipartUploadId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multipartUploadId", multipartUploadId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getPartSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("partSizeInBytes", partSizeInBytes)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadListElement
  ) extends zio.aws.glacier.model.UploadListElement.ReadOnly {
    override val multipartUploadId: Option[String] =
      scala.Option(impl.multipartUploadId()).map(value => value: String)
    override val vaultARN: Option[String] =
      scala.Option(impl.vaultARN()).map(value => value: String)
    override val archiveDescription: Option[String] =
      scala.Option(impl.archiveDescription()).map(value => value: String)
    override val partSizeInBytes: Option[Long] =
      scala.Option(impl.partSizeInBytes()).map(value => value: Long)
    override val creationDate: Option[String] =
      scala.Option(impl.creationDate()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadListElement
  ): zio.aws.glacier.model.UploadListElement.ReadOnly = new Wrapper(impl)
}
