package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VaultAccessPolicy(policy: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.VaultAccessPolicy = {
    import VaultAccessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.VaultAccessPolicy
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.VaultAccessPolicy.ReadOnly =
    zio.aws.glacier.model.VaultAccessPolicy.wrap(buildAwsValue())
}
object VaultAccessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.VaultAccessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.VaultAccessPolicy =
      zio.aws.glacier.model.VaultAccessPolicy(policy.map(value => value))
    def policy: Option[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.VaultAccessPolicy
  ) extends zio.aws.glacier.model.VaultAccessPolicy.ReadOnly {
    override val policy: Option[String] =
      scala.Option(impl.policy()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.VaultAccessPolicy
  ): zio.aws.glacier.model.VaultAccessPolicy.ReadOnly = new Wrapper(impl)
}
