package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VaultNotificationConfig(
    snsTopic: Option[String] = None,
    events: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.VaultNotificationConfig = {
    import VaultNotificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
      .builder()
      .optionallyWith(snsTopic.map(value => value: java.lang.String))(
        _.snsTopic
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.VaultNotificationConfig.ReadOnly =
    zio.aws.glacier.model.VaultNotificationConfig.wrap(buildAwsValue())
}
object VaultNotificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.VaultNotificationConfig =
      zio.aws.glacier.model.VaultNotificationConfig(
        snsTopic.map(value => value),
        events.map(value => value)
      )
    def snsTopic: Option[String]
    def events: Option[List[String]]
    def getSnsTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getEvents: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ) extends zio.aws.glacier.model.VaultNotificationConfig.ReadOnly {
    override val snsTopic: Option[String] =
      scala.Option(impl.snsTopic()).map(value => value: String)
    override val events: Option[List[String]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ): zio.aws.glacier.model.VaultNotificationConfig.ReadOnly = new Wrapper(impl)
}
