package zio.aws.glacier
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.glacier.model.primitives.{TagValue, TagKey}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object DateTime extends Subtype[String]
    type DateTime = zio.aws.glacier.model.primitives.DateTime.Type
    object Httpstatus extends Subtype[Int]
    type Httpstatus = zio.aws.glacier.model.primitives.Httpstatus.Type
    type NullableLong = Long
    object Size extends Subtype[Long]
    type Size = zio.aws.glacier.model.primitives.Size.Type
    object Stream extends Subtype[Chunk[Byte]]
    type Stream = zio.aws.glacier.model.primitives.Stream.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.glacier.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.glacier.model.primitives.TagValue.Type
  }
  type AccessControlPolicyList = List[zio.aws.glacier.model.Grant]
  type DataRetrievalRulesList = List[zio.aws.glacier.model.DataRetrievalRule]
  type Hashmap = Map[String, String]
  type JobList = List[zio.aws.glacier.model.GlacierJobDescription]
  type NotificationEventList = List[String]
  type PartList = List[zio.aws.glacier.model.PartListElement]
  type ProvisionedCapacityList =
    List[zio.aws.glacier.model.ProvisionedCapacityDescription]
  type TagKeyList = List[String]
  type TagMap = Map[TagKey, TagValue]
  type UploadsList = List[zio.aws.glacier.model.UploadListElement]
  type VaultList = List[zio.aws.glacier.model.DescribeVaultOutput]
}
