package zio.aws.glacier
import zio.aws.glacier.model.UploadArchiveResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.glacier.GlacierAsyncClient
import zio.aws.glacier.model.{
  InitiateMultipartUploadRequest,
  SetVaultNotificationsRequest,
  CreateVaultRequest,
  RemoveTagsFromVaultRequest,
  DescribeVaultRequest,
  PurchaseProvisionedCapacityRequest,
  ListJobsRequest,
  GetVaultNotificationsRequest,
  CompleteVaultLockRequest,
  DescribeJobRequest,
  InitiateVaultLockRequest,
  GetJobOutputRequest,
  AbortMultipartUploadRequest,
  DeleteVaultNotificationsRequest,
  SetDataRetrievalPolicyRequest,
  InitiateJobRequest,
  ListMultipartUploadsRequest,
  ListProvisionedCapacityRequest,
  DeleteVaultRequest,
  ListTagsForVaultRequest,
  DeleteArchiveRequest,
  GetVaultLockRequest,
  ListVaultsRequest,
  CompleteMultipartUploadRequest,
  UploadArchiveRequest,
  DeleteVaultAccessPolicyRequest,
  ListPartsRequest,
  GetVaultAccessPolicyRequest,
  SetVaultAccessPolicyRequest,
  AbortVaultLockRequest,
  AddTagsToVaultRequest,
  GetDataRetrievalPolicyRequest,
  UploadMultipartPartRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object GlacierMock extends Mock[Glacier] {
  object CompleteVaultLock
      extends Effect[CompleteVaultLockRequest, AwsError, Unit]
  object DescribeJob
      extends Effect[
        DescribeJobRequest,
        AwsError,
        zio.aws.glacier.model.DescribeJobResponse.ReadOnly
      ]
  object DeleteVaultAccessPolicy
      extends Effect[DeleteVaultAccessPolicyRequest, AwsError, Unit]
  object DeleteVaultNotifications
      extends Effect[DeleteVaultNotificationsRequest, AwsError, Unit]
  object UploadMultipartPart
      extends Effect[
        Tuple2[UploadMultipartPartRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly
      ]
  object ListVaults
      extends Stream[
        ListVaultsRequest,
        AwsError,
        zio.aws.glacier.model.DescribeVaultOutput.ReadOnly
      ]
  object ListVaultsPaginated
      extends Effect[
        ListVaultsRequest,
        AwsError,
        zio.aws.glacier.model.ListVaultsResponse.ReadOnly
      ]
  object ListMultipartUploads
      extends Stream[
        ListMultipartUploadsRequest,
        AwsError,
        zio.aws.glacier.model.UploadListElement.ReadOnly
      ]
  object ListMultipartUploadsPaginated
      extends Effect[
        ListMultipartUploadsRequest,
        AwsError,
        zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly
      ]
  object ListProvisionedCapacity
      extends Effect[
        ListProvisionedCapacityRequest,
        AwsError,
        zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly
      ]
  object ListParts
      extends Stream[
        ListPartsRequest,
        AwsError,
        zio.aws.glacier.model.PartListElement.ReadOnly
      ]
  object ListPartsPaginated
      extends Effect[
        ListPartsRequest,
        AwsError,
        zio.aws.glacier.model.ListPartsResponse.ReadOnly
      ]
  object RemoveTagsFromVault
      extends Effect[RemoveTagsFromVaultRequest, AwsError, Unit]
  object DeleteArchive extends Effect[DeleteArchiveRequest, AwsError, Unit]
  object PurchaseProvisionedCapacity
      extends Effect[
        PurchaseProvisionedCapacityRequest,
        AwsError,
        zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly
      ]
  object DescribeVault
      extends Effect[
        DescribeVaultRequest,
        AwsError,
        zio.aws.glacier.model.DescribeVaultResponse.ReadOnly
      ]
  object InitiateVaultLock
      extends Effect[
        InitiateVaultLockRequest,
        AwsError,
        zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly
      ]
  object InitiateMultipartUpload
      extends Effect[
        InitiateMultipartUploadRequest,
        AwsError,
        zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly
      ]
  object GetDataRetrievalPolicy
      extends Effect[
        GetDataRetrievalPolicyRequest,
        AwsError,
        zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly
      ]
  object GetVaultNotifications
      extends Effect[
        GetVaultNotificationsRequest,
        AwsError,
        zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly
      ]
  object AddTagsToVault extends Effect[AddTagsToVaultRequest, AwsError, Unit]
  object GetVaultLock
      extends Effect[
        GetVaultLockRequest,
        AwsError,
        zio.aws.glacier.model.GetVaultLockResponse.ReadOnly
      ]
  object DeleteVault extends Effect[DeleteVaultRequest, AwsError, Unit]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.glacier.model.GlacierJobDescription.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.glacier.model.ListJobsResponse.ReadOnly
      ]
  object AbortVaultLock extends Effect[AbortVaultLockRequest, AwsError, Unit]
  object SetVaultAccessPolicy
      extends Effect[SetVaultAccessPolicyRequest, AwsError, Unit]
  object GetVaultAccessPolicy
      extends Effect[
        GetVaultAccessPolicyRequest,
        AwsError,
        zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly
      ]
  object ListTagsForVault
      extends Effect[
        ListTagsForVaultRequest,
        AwsError,
        zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly
      ]
  object UploadArchive
      extends Effect[
        Tuple2[UploadArchiveRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        ReadOnly
      ]
  object InitiateJob
      extends Effect[
        InitiateJobRequest,
        AwsError,
        zio.aws.glacier.model.InitiateJobResponse.ReadOnly
      ]
  object SetVaultNotifications
      extends Effect[SetVaultNotificationsRequest, AwsError, Unit]
  object AbortMultipartUpload
      extends Effect[AbortMultipartUploadRequest, AwsError, Unit]
  object CreateVault
      extends Effect[
        CreateVaultRequest,
        AwsError,
        zio.aws.glacier.model.CreateVaultResponse.ReadOnly
      ]
  object GetJobOutput
      extends Effect[GetJobOutputRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.glacier.model.GetJobOutputResponse.ReadOnly,
        Byte
      ]]
  object CompleteMultipartUpload
      extends Effect[
        CompleteMultipartUploadRequest,
        AwsError,
        zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly
      ]
  object SetDataRetrievalPolicy
      extends Effect[SetDataRetrievalPolicyRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Glacier] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Glacier] { rts =>
        zio.ZIO.succeed {
          new Glacier {
            val api: GlacierAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Glacier = this
            def completeVaultLock(
                request: CompleteVaultLockRequest
            ): IO[AwsError, Unit] = proxy(CompleteVaultLock, request)
            def describeJob(request: DescribeJobRequest): IO[
              AwsError,
              zio.aws.glacier.model.DescribeJobResponse.ReadOnly
            ] = proxy(DescribeJob, request)
            def deleteVaultAccessPolicy(
                request: DeleteVaultAccessPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteVaultAccessPolicy, request)
            def deleteVaultNotifications(
                request: DeleteVaultNotificationsRequest
            ): IO[AwsError, Unit] = proxy(DeleteVaultNotifications, request)
            def uploadMultipartPart(
                request: UploadMultipartPartRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly
            ] = proxy(UploadMultipartPart, request, body)
            def listVaults(request: ListVaultsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.glacier.model.DescribeVaultOutput.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVaults, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVaultsPaginated(
                request: ListVaultsRequest
            ): IO[AwsError, zio.aws.glacier.model.ListVaultsResponse.ReadOnly] =
              proxy(ListVaultsPaginated, request)
            def listMultipartUploads(
                request: ListMultipartUploadsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.glacier.model.UploadListElement.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMultipartUploads, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMultipartUploadsPaginated(
                request: ListMultipartUploadsRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly
            ] = proxy(ListMultipartUploadsPaginated, request)
            def listProvisionedCapacity(
                request: ListProvisionedCapacityRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly
            ] = proxy(ListProvisionedCapacity, request)
            def listParts(request: ListPartsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.glacier.model.PartListElement.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListParts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPartsPaginated(
                request: ListPartsRequest
            ): IO[AwsError, zio.aws.glacier.model.ListPartsResponse.ReadOnly] =
              proxy(ListPartsPaginated, request)
            def removeTagsFromVault(
                request: RemoveTagsFromVaultRequest
            ): IO[AwsError, Unit] = proxy(RemoveTagsFromVault, request)
            def deleteArchive(
                request: DeleteArchiveRequest
            ): IO[AwsError, Unit] = proxy(DeleteArchive, request)
            def purchaseProvisionedCapacity(
                request: PurchaseProvisionedCapacityRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly
            ] = proxy(PurchaseProvisionedCapacity, request)
            def describeVault(request: DescribeVaultRequest): IO[
              AwsError,
              zio.aws.glacier.model.DescribeVaultResponse.ReadOnly
            ] = proxy(DescribeVault, request)
            def initiateVaultLock(request: InitiateVaultLockRequest): IO[
              AwsError,
              zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly
            ] = proxy(InitiateVaultLock, request)
            def initiateMultipartUpload(
                request: InitiateMultipartUploadRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly
            ] = proxy(InitiateMultipartUpload, request)
            def getDataRetrievalPolicy(
                request: GetDataRetrievalPolicyRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly
            ] = proxy(GetDataRetrievalPolicy, request)
            def getVaultNotifications(
                request: GetVaultNotificationsRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly
            ] = proxy(GetVaultNotifications, request)
            def addTagsToVault(
                request: AddTagsToVaultRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToVault, request)
            def getVaultLock(request: GetVaultLockRequest): IO[
              AwsError,
              zio.aws.glacier.model.GetVaultLockResponse.ReadOnly
            ] = proxy(GetVaultLock, request)
            def deleteVault(request: DeleteVaultRequest): IO[AwsError, Unit] =
              proxy(DeleteVault, request)
            def listJobs(request: ListJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.glacier.model.GlacierJobDescription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listJobsPaginated(
                request: ListJobsRequest
            ): IO[AwsError, zio.aws.glacier.model.ListJobsResponse.ReadOnly] =
              proxy(ListJobsPaginated, request)
            def abortVaultLock(
                request: AbortVaultLockRequest
            ): IO[AwsError, Unit] = proxy(AbortVaultLock, request)
            def setVaultAccessPolicy(
                request: SetVaultAccessPolicyRequest
            ): IO[AwsError, Unit] = proxy(SetVaultAccessPolicy, request)
            def getVaultAccessPolicy(request: GetVaultAccessPolicyRequest): IO[
              AwsError,
              zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly
            ] = proxy(GetVaultAccessPolicy, request)
            def listTagsForVault(request: ListTagsForVaultRequest): IO[
              AwsError,
              zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly
            ] = proxy(ListTagsForVault, request)
            def uploadArchive(
                request: UploadArchiveRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, ReadOnly] = proxy(UploadArchive, request, body)
            def initiateJob(request: InitiateJobRequest): IO[
              AwsError,
              zio.aws.glacier.model.InitiateJobResponse.ReadOnly
            ] = proxy(InitiateJob, request)
            def setVaultNotifications(
                request: SetVaultNotificationsRequest
            ): IO[AwsError, Unit] = proxy(SetVaultNotifications, request)
            def abortMultipartUpload(
                request: AbortMultipartUploadRequest
            ): IO[AwsError, Unit] = proxy(AbortMultipartUpload, request)
            def createVault(request: CreateVaultRequest): IO[
              AwsError,
              zio.aws.glacier.model.CreateVaultResponse.ReadOnly
            ] = proxy(CreateVault, request)
            def getJobOutput(
                request: GetJobOutputRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.glacier.model.GetJobOutputResponse.ReadOnly,
              Byte
            ]] = proxy(GetJobOutput, request)
            def completeMultipartUpload(
                request: CompleteMultipartUploadRequest
            ): IO[
              AwsError,
              zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly
            ] = proxy(CompleteMultipartUpload, request)
            def setDataRetrievalPolicy(
                request: SetDataRetrievalPolicyRequest
            ): IO[AwsError, Unit] = proxy(SetDataRetrievalPolicy, request)
          }
        }
      }
    }
  }
}
