package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.{TagValue, TagKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddTagsToVaultRequest(
    accountId: String,
    vaultName: String,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest = {
    import AddTagsToVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.AddTagsToVaultRequest.ReadOnly =
    zio.aws.glacier.model.AddTagsToVaultRequest.wrap(buildAwsValue())
}
object AddTagsToVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.AddTagsToVaultRequest =
      zio.aws.glacier.model
        .AddTagsToVaultRequest(accountId, vaultName, tags.map(value => value))
    def accountId: String
    def vaultName: String
    def tags: Optional[Map[TagKey, TagValue]]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest
  ) extends zio.aws.glacier.model.AddTagsToVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.glacier.model.primitives
              .TagKey(key) -> zio.aws.glacier.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest
  ): zio.aws.glacier.model.AddTagsToVaultRequest.ReadOnly = new Wrapper(impl)
}
