package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait CannedACL {
  def unwrap: software.amazon.awssdk.services.glacier.model.CannedACL
}
object CannedACL {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.CannedACL
  ): zio.aws.glacier.model.CannedACL = value match {
    case software.amazon.awssdk.services.glacier.model.CannedACL.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.glacier.model.CannedACL.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.UNKNOWN_TO_SDK_VERSION
  }
  case object `private` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.PRIVATE
  }
  case object `public-read` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.PUBLIC_READ
  }
  case object `public-read-write` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.PUBLIC_READ_WRITE
  }
  case object `aws-exec-read` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.AWS_EXEC_READ
  }
  case object `authenticated-read` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.AUTHENTICATED_READ
  }
  case object `bucket-owner-read` extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends zio.aws.glacier.model.CannedACL {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.CannedACL =
      software.amazon.awssdk.services.glacier.model.CannedACL.BUCKET_OWNER_FULL_CONTROL
  }
}
