package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CompleteVaultLockRequest(
    accountId: String,
    vaultName: String,
    lockId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest = {
    import CompleteVaultLockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .lockId(lockId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CompleteVaultLockRequest.ReadOnly =
    zio.aws.glacier.model.CompleteVaultLockRequest.wrap(buildAwsValue())
}
object CompleteVaultLockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CompleteVaultLockRequest =
      zio.aws.glacier.model
        .CompleteVaultLockRequest(accountId, vaultName, lockId)
    def accountId: String
    def vaultName: String
    def lockId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getLockId: ZIO[Any, Nothing, String] = ZIO.succeed(lockId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest
  ) extends zio.aws.glacier.model.CompleteVaultLockRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val lockId: String = impl.lockId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest
  ): zio.aws.glacier.model.CompleteVaultLockRequest.ReadOnly = new Wrapper(impl)
}
