package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataRetrievalPolicy(
    rules: Optional[Iterable[zio.aws.glacier.model.DataRetrievalRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy = {
    import DataRetrievalPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly =
    zio.aws.glacier.model.DataRetrievalPolicy.wrap(buildAwsValue())
}
object DataRetrievalPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DataRetrievalPolicy =
      zio.aws.glacier.model.DataRetrievalPolicy(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[List[zio.aws.glacier.model.DataRetrievalRule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.DataRetrievalRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy
  ) extends zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly {
    override val rules
        : Optional[List[zio.aws.glacier.model.DataRetrievalRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.glacier.model.DataRetrievalRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DataRetrievalPolicy
  ): zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly = new Wrapper(impl)
}
