package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteArchiveRequest(
    accountId: String,
    vaultName: String,
    archiveId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest = {
    import DeleteArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .archiveId(archiveId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DeleteArchiveRequest.ReadOnly =
    zio.aws.glacier.model.DeleteArchiveRequest.wrap(buildAwsValue())
}
object DeleteArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DeleteArchiveRequest =
      zio.aws.glacier.model
        .DeleteArchiveRequest(accountId, vaultName, archiveId)
    def accountId: String
    def vaultName: String
    def archiveId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getArchiveId: ZIO[Any, Nothing, String] = ZIO.succeed(archiveId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest
  ) extends zio.aws.glacier.model.DeleteArchiveRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val archiveId: String = impl.archiveId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest
  ): zio.aws.glacier.model.DeleteArchiveRequest.ReadOnly = new Wrapper(impl)
}
