package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVaultAccessPolicyRequest(
    accountId: String,
    vaultName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest = {
    import DeleteVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.DeleteVaultAccessPolicyRequest.ReadOnly =
    zio.aws.glacier.model.DeleteVaultAccessPolicyRequest.wrap(buildAwsValue())
}
object DeleteVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DeleteVaultAccessPolicyRequest =
      zio.aws.glacier.model.DeleteVaultAccessPolicyRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest
  ) extends zio.aws.glacier.model.DeleteVaultAccessPolicyRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest
  ): zio.aws.glacier.model.DeleteVaultAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
