package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVaultNotificationsRequest(
    accountId: String,
    vaultName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest = {
    import DeleteVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.DeleteVaultNotificationsRequest.ReadOnly =
    zio.aws.glacier.model.DeleteVaultNotificationsRequest.wrap(buildAwsValue())
}
object DeleteVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DeleteVaultNotificationsRequest =
      zio.aws.glacier.model
        .DeleteVaultNotificationsRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest
  ) extends zio.aws.glacier.model.DeleteVaultNotificationsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest
  ): zio.aws.glacier.model.DeleteVaultNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
