package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVaultRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DeleteVaultRequest = {
    import DeleteVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DeleteVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DeleteVaultRequest.ReadOnly =
    zio.aws.glacier.model.DeleteVaultRequest.wrap(buildAwsValue())
}
object DeleteVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DeleteVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DeleteVaultRequest =
      zio.aws.glacier.model.DeleteVaultRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultRequest
  ) extends zio.aws.glacier.model.DeleteVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DeleteVaultRequest
  ): zio.aws.glacier.model.DeleteVaultRequest.ReadOnly = new Wrapper(impl)
}
