package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeJobRequest(
    accountId: String,
    vaultName: String,
    jobId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DescribeJobRequest = {
    import DescribeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DescribeJobRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .jobId(jobId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DescribeJobRequest.ReadOnly =
    zio.aws.glacier.model.DescribeJobRequest.wrap(buildAwsValue())
}
object DescribeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DescribeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DescribeJobRequest =
      zio.aws.glacier.model.DescribeJobRequest(accountId, vaultName, jobId)
    def accountId: String
    def vaultName: String
    def jobId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DescribeJobRequest
  ) extends zio.aws.glacier.model.DescribeJobRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val jobId: String = impl.jobId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DescribeJobRequest
  ): zio.aws.glacier.model.DescribeJobRequest.ReadOnly = new Wrapper(impl)
}
