package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDataRetrievalPolicyResponse(
    policy: Optional[zio.aws.glacier.model.DataRetrievalPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse = {
    import GetDataRetrievalPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly =
    zio.aws.glacier.model.GetDataRetrievalPolicyResponse.wrap(buildAwsValue())
}
object GetDataRetrievalPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetDataRetrievalPolicyResponse =
      zio.aws.glacier.model
        .GetDataRetrievalPolicyResponse(policy.map(value => value.asEditable))
    def policy: Optional[zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse
  ) extends zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly {
    override val policy
        : Optional[zio.aws.glacier.model.DataRetrievalPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.glacier.model.DataRetrievalPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyResponse
  ): zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
