package zio.aws.glacier.model
import zio.prelude.data.Optional
import zio.aws.glacier.model.primitives.Httpstatus
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetJobOutputResponse(
    checksum: Optional[String] = Optional.Absent,
    status: Optional[Httpstatus] = Optional.Absent,
    contentRange: Optional[String] = Optional.Absent,
    acceptRanges: Optional[String] = Optional.Absent,
    contentType: Optional[String] = Optional.Absent,
    archiveDescription: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetJobOutputResponse = {
    import GetJobOutputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
      .builder()
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(status.map(value => Httpstatus.unwrap(value): Integer))(
        _.status
      )
      .optionallyWith(contentRange.map(value => value: java.lang.String))(
        _.contentRange
      )
      .optionallyWith(acceptRanges.map(value => value: java.lang.String))(
        _.acceptRanges
      )
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetJobOutputResponse.ReadOnly =
    zio.aws.glacier.model.GetJobOutputResponse.wrap(buildAwsValue())
}
object GetJobOutputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetJobOutputResponse =
      zio.aws.glacier.model.GetJobOutputResponse(
        checksum.map(value => value),
        status.map(value => value),
        contentRange.map(value => value),
        acceptRanges.map(value => value),
        contentType.map(value => value),
        archiveDescription.map(value => value)
      )
    def checksum: Optional[String]
    def status: Optional[Httpstatus]
    def contentRange: Optional[String]
    def acceptRanges: Optional[String]
    def contentType: Optional[String]
    def archiveDescription: Optional[String]
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getStatus: ZIO[Any, AwsError, Httpstatus] =
      AwsError.unwrapOptionField("status", status)
    def getContentRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentRange", contentRange)
    def getAcceptRanges: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ) extends zio.aws.glacier.model.GetJobOutputResponse.ReadOnly {
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
    override val status: Optional[Httpstatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.glacier.model.primitives.Httpstatus(value))
    override val contentRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentRange())
      .map(value => value: String)
    override val acceptRanges: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptRanges())
      .map(value => value: String)
    override val contentType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => value: String)
    override val archiveDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveDescription())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ): zio.aws.glacier.model.GetJobOutputResponse.ReadOnly = new Wrapper(impl)
}
