package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVaultAccessPolicyRequest(
    accountId: String,
    vaultName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest = {
    import GetVaultAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultAccessPolicyRequest.ReadOnly =
    zio.aws.glacier.model.GetVaultAccessPolicyRequest.wrap(buildAwsValue())
}
object GetVaultAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultAccessPolicyRequest =
      zio.aws.glacier.model.GetVaultAccessPolicyRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest
  ) extends zio.aws.glacier.model.GetVaultAccessPolicyRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest
  ): zio.aws.glacier.model.GetVaultAccessPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
