package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVaultAccessPolicyResponse(
    policy: Optional[zio.aws.glacier.model.VaultAccessPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse = {
    import GetVaultAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly =
    zio.aws.glacier.model.GetVaultAccessPolicyResponse.wrap(buildAwsValue())
}
object GetVaultAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultAccessPolicyResponse =
      zio.aws.glacier.model
        .GetVaultAccessPolicyResponse(policy.map(value => value.asEditable))
    def policy: Optional[zio.aws.glacier.model.VaultAccessPolicy.ReadOnly]
    def getPolicy
        : ZIO[Any, AwsError, zio.aws.glacier.model.VaultAccessPolicy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse
  ) extends zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly {
    override val policy
        : Optional[zio.aws.glacier.model.VaultAccessPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.glacier.model.VaultAccessPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyResponse
  ): zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
