package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVaultLockResponse(
    policy: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    expirationDate: Optional[String] = Optional.Absent,
    creationDate: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultLockResponse = {
    import GetVaultLockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultLockResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(expirationDate.map(value => value: java.lang.String))(
        _.expirationDate
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultLockResponse.ReadOnly =
    zio.aws.glacier.model.GetVaultLockResponse.wrap(buildAwsValue())
}
object GetVaultLockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultLockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultLockResponse =
      zio.aws.glacier.model.GetVaultLockResponse(
        policy.map(value => value),
        state.map(value => value),
        expirationDate.map(value => value),
        creationDate.map(value => value)
      )
    def policy: Optional[String]
    def state: Optional[String]
    def expirationDate: Optional[String]
    def creationDate: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getExpirationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultLockResponse
  ) extends zio.aws.glacier.model.GetVaultLockResponse.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val expirationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => value: String)
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultLockResponse
  ): zio.aws.glacier.model.GetVaultLockResponse.ReadOnly = new Wrapper(impl)
}
