package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Grantee(
    `type`: zio.aws.glacier.model.Type,
    displayName: Optional[String] = Optional.Absent,
    uri: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    emailAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.glacier.model.Grantee = {
    import Grantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.Grantee
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(uri.map(value => value: java.lang.String))(_.uri)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(emailAddress.map(value => value: java.lang.String))(
        _.emailAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.Grantee.ReadOnly =
    zio.aws.glacier.model.Grantee.wrap(buildAwsValue())
}
object Grantee {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.glacier.model.Grantee] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.Grantee =
      zio.aws.glacier.model.Grantee(
        `type`,
        displayName.map(value => value),
        uri.map(value => value),
        id.map(value => value),
        emailAddress.map(value => value)
      )
    def `type`: zio.aws.glacier.model.Type
    def displayName: Optional[String]
    def uri: Optional[String]
    def id: Optional[String]
    def emailAddress: Optional[String]
    def getType: ZIO[Any, Nothing, zio.aws.glacier.model.Type] =
      ZIO.succeed(`type`)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uri", uri)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getEmailAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.Grantee
  ) extends zio.aws.glacier.model.Grantee.ReadOnly {
    override val `type`: zio.aws.glacier.model.Type =
      zio.aws.glacier.model.Type.wrap(impl.`type`())
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val uri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val emailAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.Grantee
  ): zio.aws.glacier.model.Grantee.ReadOnly = new Wrapper(impl)
}
