package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InitiateJobRequest(
    accountId: String,
    vaultName: String,
    jobParameters: Optional[zio.aws.glacier.model.JobParameters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateJobRequest = {
    import InitiateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateJobRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(jobParameters.map(value => value.buildAwsValue()))(
        _.jobParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InitiateJobRequest.ReadOnly =
    zio.aws.glacier.model.InitiateJobRequest.wrap(buildAwsValue())
}
object InitiateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateJobRequest =
      zio.aws.glacier.model.InitiateJobRequest(
        accountId,
        vaultName,
        jobParameters.map(value => value.asEditable)
      )
    def accountId: String
    def vaultName: String
    def jobParameters: Optional[zio.aws.glacier.model.JobParameters.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getJobParameters
        : ZIO[Any, AwsError, zio.aws.glacier.model.JobParameters.ReadOnly] =
      AwsError.unwrapOptionField("jobParameters", jobParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateJobRequest
  ) extends zio.aws.glacier.model.InitiateJobRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val jobParameters
        : Optional[zio.aws.glacier.model.JobParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobParameters())
        .map(value => zio.aws.glacier.model.JobParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateJobRequest
  ): zio.aws.glacier.model.InitiateJobRequest.ReadOnly = new Wrapper(impl)
}
