package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InventoryRetrievalJobInput(
    startDate: Optional[String] = Optional.Absent,
    endDate: Optional[String] = Optional.Absent,
    limit: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput = {
    import InventoryRetrievalJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
      .builder()
      .optionallyWith(startDate.map(value => value: java.lang.String))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly =
    zio.aws.glacier.model.InventoryRetrievalJobInput.wrap(buildAwsValue())
}
object InventoryRetrievalJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InventoryRetrievalJobInput =
      zio.aws.glacier.model.InventoryRetrievalJobInput(
        startDate.map(value => value),
        endDate.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def startDate: Optional[String]
    def endDate: Optional[String]
    def limit: Optional[String]
    def marker: Optional[String]
    def getStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ) extends zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly {
    override val startDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => value: String)
    override val endDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => value: String)
    override val limit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobInput
  ): zio.aws.glacier.model.InventoryRetrievalJobInput.ReadOnly = new Wrapper(
    impl
  )
}
