package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobsResponse(
    jobList: Optional[Iterable[zio.aws.glacier.model.GlacierJobDescription]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListJobsResponse
      .builder()
      .optionallyWith(
        jobList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListJobsResponse.ReadOnly =
    zio.aws.glacier.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListJobsResponse =
      zio.aws.glacier.model.ListJobsResponse(
        jobList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def jobList
        : Optional[List[zio.aws.glacier.model.GlacierJobDescription.ReadOnly]]
    def marker: Optional[String]
    def getJobList: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.GlacierJobDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("jobList", jobList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListJobsResponse
  ) extends zio.aws.glacier.model.ListJobsResponse.ReadOnly {
    override val jobList
        : Optional[List[zio.aws.glacier.model.GlacierJobDescription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.glacier.model.GlacierJobDescription.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListJobsResponse
  ): zio.aws.glacier.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
